/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import moze_intel.projecte.api.event.PlayerAttemptCondenserSetEvent;
import moze_intel.projecte.capability.managing.BasicCapabilityResolver;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.EmcChestBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.WrappedItemHandler;
import moze_intel.projecte.gameObjs.container.CondenserContainer;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CondenserBlockEntity
extends EmcChestBlockEntity {
    protected final ItemStackHandler inputInventory = this.createInput();
    private final ItemStackHandler outputInventory = this.createOutput();
    @Nullable
    private ItemInfo lockInfo;
    private boolean isAcceptingEmc;
    public long displayEmc;
    public long requiredEmc;
    private int loadIndex = EMCMappingHandler.getLoadIndex() - 1;

    public CondenserBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityTypeRegistryObject<? extends CondenserBlockEntity>)PEBlockEntityTypes.CONDENSER, pos, state);
    }

    protected CondenserBlockEntity(BlockEntityTypeRegistryObject<? extends CondenserBlockEntity> type, BlockPos pos, BlockState state) {
        super((BlockEntityTypeRegistryObject<? extends EmcChestBlockEntity>)type, pos, state);
        this.itemHandlerResolver = BasicCapabilityResolver.getBasicItemHandlerResolver((NonNullSupplier<IItemHandler>)((NonNullSupplier)this::createAutomationInventory));
    }

    @Override
    protected boolean canAcceptEmc() {
        return this.isAcceptingEmc;
    }

    @Override
    protected boolean canProvideEmc() {
        return false;
    }

    @Nullable
    public final ItemInfo getLockInfo() {
        if (!(this.requiredEmc != 0L || this.f_58857_ != null && this.f_58857_.f_46443_)) {
            return null;
        }
        return this.lockInfo;
    }

    public ItemStackHandler getInput() {
        return this.inputInventory;
    }

    public ItemStackHandler getOutput() {
        return this.outputInventory;
    }

    protected ItemStackHandler createInput() {
        return new EmcBlockEntity.StackHandler(this, 91);
    }

    protected ItemStackHandler createOutput() {
        return this.inputInventory;
    }

    @NotNull
    protected IItemHandler createAutomationInventory() {
        return new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN_OUT){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return SlotPredicates.HAS_EMC.test(stack) && !CondenserBlockEntity.this.isStackEqualToLock(stack) ? super.insertItem(slot, stack, simulate) : stack;
            }

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int max, boolean simulate) {
                if (!this.getStackInSlot(slot).m_41619_() && CondenserBlockEntity.this.isStackEqualToLock(this.getStackInSlot(slot))) {
                    return super.extractItem(slot, max, simulate);
                }
                return ItemStack.f_41583_;
            }
        };
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, CondenserBlockEntity condenser) {
        condenser.checkLockAndUpdate(false);
        condenser.displayEmc = condenser.getStoredEmc();
        if (condenser.getLockInfo() != null) {
            condenser.condense();
        }
        condenser.updateComparators();
    }

    private void checkLockAndUpdate(boolean force) {
        long lockEmc;
        if (!force && this.loadIndex == EMCMappingHandler.getLoadIndex()) {
            return;
        }
        this.loadIndex = EMCMappingHandler.getLoadIndex();
        if (this.lockInfo != null && (lockEmc = EMCHelper.getEmcValue(this.lockInfo)) > 0L) {
            if (this.requiredEmc != lockEmc) {
                this.requiredEmc = lockEmc;
                this.isAcceptingEmc = true;
            }
            return;
        }
        this.displayEmc = 0L;
        this.requiredEmc = 0L;
        this.isAcceptingEmc = false;
    }

    protected void condense() {
        for (int i = 0; i < this.inputInventory.getSlots(); ++i) {
            ItemStack stack = this.inputInventory.getStackInSlot(i);
            if (stack.m_41619_() || this.isStackEqualToLock(stack)) continue;
            this.inputInventory.extractItem(i, 1, false);
            this.forceInsertEmc(EMCHelper.getEmcSellValue(stack), IEmcStorage.EmcAction.EXECUTE);
            break;
        }
        if (this.getStoredEmc() >= this.requiredEmc && this.hasSpace()) {
            this.forceExtractEmc(this.requiredEmc, IEmcStorage.EmcAction.EXECUTE);
            this.pushStack();
        }
    }

    protected final void pushStack() {
        ItemInfo lockInfo = this.getLockInfo();
        if (lockInfo != null) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)lockInfo.createStack(), (boolean)false);
        }
    }

    protected boolean hasSpace() {
        for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
            ItemStack stack = this.outputInventory.getStackInSlot(i);
            if (!stack.m_41619_() && (!this.isStackEqualToLock(stack) || stack.m_41613_() >= stack.m_41741_())) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEqualToLock(ItemStack stack) {
        ItemInfo lockInfo = this.getLockInfo();
        if (lockInfo == null || stack.m_41619_()) {
            return false;
        }
        return lockInfo.equals(NBTManager.getPersistentInfo(ItemInfo.fromStack(stack)));
    }

    public void setLockInfoFromPacket(@Nullable ItemInfo lockInfo) {
        this.lockInfo = lockInfo;
    }

    public boolean attemptCondenserSet(Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return false;
        }
        if (this.getLockInfo() == null) {
            ItemStack stack = player.f_36096_.m_142621_();
            if (!stack.m_41619_()) {
                ItemInfo reducedInfo;
                ItemInfo sourceInfo = ItemInfo.fromStack(stack);
                if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerAttemptCondenserSetEvent(player, sourceInfo, reducedInfo = NBTManager.getPersistentInfo(sourceInfo)))) {
                    this.lockInfo = reducedInfo;
                    this.checkLockAndUpdate(true);
                    this.markDirty(false);
                    return true;
                }
                return false;
            }
            if (this.lockInfo == null) {
                return false;
            }
        }
        this.lockInfo = null;
        this.checkLockAndUpdate(true);
        this.markDirty(false);
        return true;
    }

    @Override
    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inputInventory.deserializeNBT(nbt.m_128469_("Input"));
        this.lockInfo = ItemInfo.read(nbt.m_128469_("LockInfo"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Input", (Tag)this.inputInventory.serializeNBT());
        if (this.lockInfo != null) {
            tag.m_128365_("LockInfo", (Tag)this.lockInfo.write(new CompoundTag()));
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerIn) {
        return new CondenserContainer(windowId, playerInventory, this);
    }

    @NotNull
    public Component m_5446_() {
        return TextComponentUtil.build(PEBlocks.CONDENSER);
    }
}

